$IconStackedTime = 1.5;

$IconHungerState = 3;
$IconHungerExtent = "44 48";
$IconHungerBitmap = "assets/client/ui/icons/hungerbubble.png";
$IconHungerWorldOff = "0 0 5.5";
$IconHungerScreenOff = "12 3";

$IconUnhappinessState = 4;
$IconUnhappinessExtent = "44 48";
$IconUnhappinessBitmap = "assets/client/ui/icons/angrybubble.png";
$IconUnhappinessWorldOff = "0 0 5.5";
$IconUnhappinessScreenOff = "12 3";


//-Normal-----------------------------------------------------------------------
////////////////////////////////////////////////////////////////////////////////
//! Normal Hunger Enter
//! \param %cmpAI AI component of character
////////////////////////////////////////////////////////////////////////////////
function AISMN_MonitorHungerNormal::OnEnter(%this,%cmpAI)
{
   echo("Hunger Normal");
   return;
}

////////////////////////////////////////////////////////////////////////////////
//! Normal Hunger Exit
//! \param %cmpAI AI component of character
////////////////////////////////////////////////////////////////////////////////
function AISMN_MonitorHungerNormal::OnExit(%this,%cmpAI)
{
   return;
}

////////////////////////////////////////////////////////////////////////////////
//! Normal Hunger Update
//! \param %cmpAI AI component of character
////////////////////////////////////////////////////////////////////////////////
function AISMN_MonitorHungerNormal::Update(%this,%cmpAI)
{
   // Go to stage one hunger
   if(IsHungry(%cmpAI) && AreMonitoringHunger()) {
      ReturnValue(%cmpAI,0);
   }
   
   // Remain in normal state
   else {
      ReturnValue(%cmpAI,-1);
   }
   return;
}
//------------------------------------------------------------------------------


//-Stage One--------------------------------------------------------------------
////////////////////////////////////////////////////////////////////////////////
//! Stage One Hunger Enter
//! \param %cmpAI AI component of character
////////////////////////////////////////////////////////////////////////////////
function AISMN_MonitorHungerStage1::OnEnter(%this,%cmpAI)
{   
   echo("Hunger Stage 1");
   return;
}

////////////////////////////////////////////////////////////////////////////////
//! Stage One Hunger Exit
//! \param %cmpAI AI component of character
////////////////////////////////////////////////////////////////////////////////
function AISMN_MonitorHungerStage1::OnExit(%this,%cmpAI)
{
   return;
}

////////////////////////////////////////////////////////////////////////////////
//! Stage One Hunger Update
//! \param %cmpAI AI component of character
////////////////////////////////////////////////////////////////////////////////
function AISMN_MonitorHungerStage1::Update(%this,%cmpAI)
{
   // Return to normal hunger monitor   
   if(!IsHungry(%cmpAI) || !AreMonitoringHunger()) {
      ReturnValue(%cmpAI,1);
      return;
   }
   
   %datablock = %cmpAI.getDataBlock();
   %totalTime = %datablock.hungerWaitTimes_0;
   
   // Go to stage two
   if(TimeInNode(%cmpAI) >= %totalTime) {
      ReturnValue(%cmpAI,0);
   }
   
   // Remain in stage one
   else {
      ReturnValue(%cmpAI,-1);
   }
   return;
}
//------------------------------------------------------------------------------


//-Stage Two--------------------------------------------------------------------
////////////////////////////////////////////////////////////////////////////////
//! Stage Two Hunger Enter
//! \param %cmpAI AI component of character
////////////////////////////////////////////////////////////////////////////////
function AISMN_MonitorHungerStage2::OnEnter(%this,%cmpAI)
{   
   echo("Hunger Stage 2");
   return;
}

////////////////////////////////////////////////////////////////////////////////
//! Stage Two Hunger Exit
//! \param %cmpAI AI component of character
////////////////////////////////////////////////////////////////////////////////
function AISMN_MonitorHungerStage2::OnExit(%this,%cmpAI)
{
   return;
}

////////////////////////////////////////////////////////////////////////////////
//! Stage Two Hunger Update
//! \param %cmpAI AI component of character
////////////////////////////////////////////////////////////////////////////////
function AISMN_MonitorHungerStage2::Update(%this,%cmpAI)
{
   // Go to normal state   
   if(!IsHungry(%cmpAI) || !AreMonitoringHunger()) {
      ReturnValue(%cmpAI,2);
      return;
   }
   
   %datablock = %cmpAI.getDataBlock();
   %totalTime = %datablock.hungerWaitTimes_1;
   
   // Leave town or go to hunger stage three
   if(TimeInNode(%cmpAI) >= %totalTime) {
      %leavePercent = %datablock.hungerLeavePercent;
      %happyMod     = %datablock.hungerLeaveHappyMod;
      %object       = GetThisObject(%cmpAI);
      %cmpChar      = slgQueryInterface(%object, $CID_CHARACTER);
      
      // Leave town
      if(CheckForMonitorEffect(%leavePercent, %happyMod, 0) 
      && !%cmpChar.inState($CharacterState::Drunk)) {
         %msg = slgGetUIString("id_character_hungerleave");
         %msg = slgFormatUIString(%msg, GetThisObject(%cmpAI).name);
         commandToClient(ClientGroup.getObject(0), 'SendHudMessage', %msg);
         %cmpAI.performAction("leave");
         ReturnValue(%cmpAI,1);
      }
      
      // Go to stage three
      else {
         ReturnValue(%cmpAI,0);
      }
   }
   
   // Stay in stage two
   else {
      ReturnValue(%cmpAI,-1);
   }
   
   return;
}
//------------------------------------------------------------------------------


//-Stage Three------------------------------------------------------------------
////////////////////////////////////////////////////////////////////////////////
//! Stage Three Hunger Enter
//! \param %cmpAI AI component of character
////////////////////////////////////////////////////////////////////////////////
function AISMN_MonitorHungerStage3::OnEnter(%this,%cmpAI)
{
   echo("Hunger Stage 3");
   return;
}

////////////////////////////////////////////////////////////////////////////////
//! Stage Three Hunger Exit
//! \param %cmpAI AI component of character
////////////////////////////////////////////////////////////////////////////////
function AISMN_MonitorHungerStage3::OnExit(%this,%cmpAI)
{
   return;
}

////////////////////////////////////////////////////////////////////////////////
//! Stage Three Hunger Update
//! \param %cmpAI AI component of character
////////////////////////////////////////////////////////////////////////////////
function AISMN_MonitorHungerStage3::Update(%this,%cmpAI)
{
   // Go to normal hunger state   
   if(!IsHungry(%cmpAI) || !AreMonitoringHunger()) {
      ReturnValue(%cmpAI,2);
      return;
   }
   
   %datablock = %cmpAI.getDataBlock();
   %totalTime = %datablock.hungerWaitTimes_2;
   
   // Go to stage four hunger or leave town
   if(TimeInNode(%cmpAI) >= %totalTime) {
      %leavePercent = %datablock.hungerLeavePercent;
      %happyMod     = %datablock.hungerLeaveHappyMod;
      %object       = GetThisObject(%cmpAI);
      %cmpChar      = slgQueryInterface(%object, $CID_CHARACTER);
      
      // Leave town
      if(CheckForMonitorEffect(%leavePercent, %happyMod, 1)
      && !%cmpChar.inState($CharacterState::Drunk)) {
         %msg = slgGetUIString("id_character_hungerleave");
         %msg = slgFormatUIString(%msg, GetThisObject(%cmpAI).name);
         commandToClient(ClientGroup.getObject(0), 'SendHudMessage', %msg);
         %cmpAI.performAction("leave");
         ReturnValue(%cmpAI,1);
      }
      
      // Go to stage four
      else {
         ReturnValue(%cmpAI,0);
      }
   }
   
   // Remain in stage three
   else {
      ReturnValue(%cmpAI,-1);
   }
   
   return;
}
//------------------------------------------------------------------------------


//-Stage Four-------------------------------------------------------------------
////////////////////////////////////////////////////////////////////////////////
//! Stage Four Hunger Enter
//! \param %cmpAI AI component of character
////////////////////////////////////////////////////////////////////////////////
function AISMN_MonitorHungerStage4::OnEnter(%this,%cmpAI)
{   
   echo("Hunger Stage 4");
   return;
}

////////////////////////////////////////////////////////////////////////////////
//! Stage Four Hunger Exit
//! \param %cmpAI AI component of character
////////////////////////////////////////////////////////////////////////////////
function AISMN_MonitorHungerStage4::OnExit(%this,%cmpAI)
{
   return;
}

////////////////////////////////////////////////////////////////////////////////
//! Stage Four Hunger Update
//! \param %cmpAI AI component of character
////////////////////////////////////////////////////////////////////////////////
function AISMN_MonitorHungerStage4::Update(%this,%cmpAI)
{
   // Return to normal hunger state   
   if(!IsHungry(%cmpAI) || !AreMonitoringHunger()) {
      ReturnValue(%cmpAI,1);
      return;
   }
   
   %datablock = %cmpAI.getDataBlock();
   %totalTime = %datablock.hungerWaitTimes_3;
   
   // Go to death state
   if(TimeInNode(%cmpAI) >= %totalTime) {
      %msg = slgGetUIString("id_character_hungerdie");
      %msg = slgFormatUIString(%msg, GetThisObject(%cmpAI).name);
      commandToClient(ClientGroup.getObject(0), 'SendHudMessage', %msg);
      %cmpAI.performAction("die");
      ReturnValue(%cmpAI,0);
   }
   
   // Remain in stage four
   else {
      ReturnValue(%cmpAI,-1);
   }
   
   return;
}
//------------------------------------------------------------------------------



function UpdateHungerIcon(%object, %count)
{
   %character = slgQueryInterface(%object, $CID_CHARACTER);
   if (isObject(%character) == true && %character.isHero() == true)
   {
      return;
   }
   
   if (%object.getTeam() != $OST_PLAYER)
   {
      return;
   }
   
   if (%count < $IconHungerState && isObject(%object.hungerIcon) == true)
   {
      %object.hungerIcon.delete();
      %object.hungerIcon = 0;
      
      CheckIconStacking(%object);
   }
   else if (%count >= $IconHungerState && isObject(%object.hungerIcon) == false)
   {
      // create a hunger icon
      %icon = new SLGuiTarget() 
      {
         extent  = $IconHungerExtent;
         bitmap  = $IconHungerBitmap;
         visible = true;
         
         // gui target fields
         target       = %object;
         renderFront  = true;
         worldOffset  = $IconHungerWorldOff;
         screenOffset = $IconHungerScreenOff;
      };
      %object.hungerIcon = %icon;
      HungerIconGroup.addGuiControl(%icon);
      
      CheckIconStacking(%object);
   }
}

function UpdateUnhappinessIcon(%object)
{
   %component = slgQueryInterface(%object, $CID_CHARACTER);
   if (isObject(%character) == true && %character.isHero() == true)
   {
      return;
   }
   
   if (%object.getTeam() != $OST_PLAYER)
   {
      return;
   }
   
   // must have AI to check if character is drunk
   %ai = slgQueryInterface(%object, $CID_AI);
   if (isObject(%ai) == false)
   {
      return;
   }
   
   %count = %object.drunkUnhappy + %object.joblessUnhappy + %object.homelessUnhappy;
   if (isObject(%component) == true) %count += %component.getHunger();
   
   if ((%count < $IconUnhappinessState || %ai.isDrunk() == true) &&
      isObject(%object.unhappinessIcon) == true)
   {
      %object.unhappinessIcon.delete();
      %object.unhappinessIcon = 0;
      
      CheckIconStacking(%object);
   }
   else if (%count >= $IconUnhappinessState && %ai.isDrunk() == false &&
      isObject(%object.unhappinessIcon) == false)
   {
      // create a hunger icon
      %icon = new SLGuiTarget() 
      {
         extent  = $IconUnhappinessExtent;
         bitmap  = $IconUnhappinessBitmap;
         visible = true;
         
         // gui target fields
         target       = %object;
         renderFront  = true;
         worldOffset  = $IconUnhappinessWorldOff;
         screenOffset = $IconUnhappinessScreenOff;
      };
      %object.unhappinessIcon = %icon;
      UnhappinessIconGroup.addGuiControl(%icon);
      
      CheckIconStacking(%object);
   }
}

function CheckIconStacking(%object)
{
   if (isObject(%object.hungerIcon) == true &&
      isObject(%object.unhappinessIcon) == true)
   {
      if (isObject(%object.stackedIcon) == true)
      {
         return;
      }
      
      %object.unhappinessIcon.visible = false;
      %object.stackedIcon = new SLTimer()
      {
         time = $IconStackedTime;
      };
      %object.stackedIcon.notifyOnFire(SwapStackedIcons, %object);
      return;
   }
   
   if (isObject(%object.stackedIcon) == true)
   {
      %object.stackedIcon.delete();
      %object.stackedIcon = 0;
   }
   
   if (isObject(%object.hungerIcon) == true)
   {
      %object.hungerIcon.visible = true;
   }
   
   if (isObject(%object.unhappinessIcon) == true)
   {
      %object.unhappinessIcon.visible = true;
   }
}

function SLGameObj::SwapStackedIcons(%object)
{
   if (isObject(%object.hungerIcon) == true &&
      isObject(%object.unhappinessIcon) == true)
   {
      if (%object.hungerIcon.visible == true)
      {
         %object.hungerIcon.visible = false;
         %object.unhappinessIcon.visible = true;
      }
      else
      {
         %object.hungerIcon.visible = true;
         %object.unhappinessIcon.visible = false;
      }
      
      %object.stackedIcon = new SLTimer()
      {
         time = $IconStackedTime;
      };
      %object.stackedIcon.notifyOnFire(SwapStackedIcons, %object);
   }
}

// End MonitorHunger.cs
